from imblearn.over_sampling import SMOTE
from imblearn.under_sampling import RandomUnderSampler
from imblearn.pipeline import Pipeline
from imblearn.over_sampling import ADASYN

def data_balancing(inputdata, output):
    over = SMOTE(sampling_strategy=0.6, k_neighbors=10)
    under = RandomUnderSampler(sampling_strategy=0.6)
    steps = [('o', over), ('u', under)]
    pipeline = Pipeline(steps=steps)
    # transform the dataset
    X, y = pipeline.fit_resample(inputdata, output)
    return X, y


def data_balancing_ADASYN(inputdata, output):
    oversample = ADASYN()
    X, y = oversample.fit_resample(inputdata, output)
    return X, y



def data_balancing_smote(inputdata, output):
    over = SMOTE(sampling_strategy=0.8,  k_neighbors=10)
    steps = [('o', over)]
    pipeline = Pipeline(steps=steps)
    # transform the dataset
    X, y = pipeline.fit_resample(inputdata, output)
    return X, y